/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.pmod.task.TaskEndedException;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerQueue;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.servlet.util.WindowOptions;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.servlet.ActionBase;
import com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet;
import com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl;
import com.ibm.hwmca.ui.bonsai.servlet.util.UIRefreshManager;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.util.GraphicsConstants;
import com.ibm.hwmca.ui.bonsai.util.SortedList;
import com.ibm.psw.wcc.context.IWccContext;
import com.ibm.psw.wcc.context.WccContext;
import com.ibm.psw.wcc.taskbar.WccTaskbar;
import com.ibm.psw.wcc.taskbar.WccTaskbarButton;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.form.WImageButton;
import com.ibm.psw.wcl.core.layout.WBoxLayout;
import com.ibm.psw.wcl.core.markup.WHyperlink;
import com.ibm.psw.wcl.core.markup.WImage;
import com.ibm.psw.wcl.core.resource.IResource;
import com.ibm.psw.wcl.core.resource.UrlResource;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.skins.base.BaseHyperlinkStyleInfo;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class TaskbarAction
extends ActionBase {
    public static final String FRAME_NAME = "taskbar_frame";
    public static final String FRAME_PATH = "frames['taskbar_frame']";
    public static final String URI = "taskbar.do";
    private static final String TRACEMASKT = "XBUITBAT";
    private static final String TRACEMASKF = "XBUITBAF";
    private static final String TRACEMASKD = "XBUITBAD";
    private String helpURI;

    public WPage perform(HttpServlet ctrlrServlet, HttpServletRequest request, HttpServletResponse response, RenderingContext rc) throws IOException, ServletException {
        HttpSession session;
        ETaskbarResources eTaskbarResources;
        if (this.helpURI == null) {
            this.helpURI = ((ControllerServlet)ctrlrServlet).getConfigBean_().getHelpURI();
        }
        if ((eTaskbarResources = (ETaskbarResources)(session = request.getSession()).getAttribute("ETaskbarResources")) == null) {
            eTaskbarResources = new ETaskbarResources();
            session.setAttribute("ETaskbarResources", (Object)eTaskbarResources);
        }
        return eTaskbarResources.getResourcesDocument(rc, session);
    }

    private String getHelpOnClickScript() {
        WindowOptions helpWindowOptions = (WindowOptions)TaskControllerQueue.DEFAULT_WINDOW_OPTIONS.clone();
        helpWindowOptions.setWidth(900);
        helpWindowOptions.setHeight(600);
        return "window.open('" + this.helpURI + "', 'help', '" + helpWindowOptions + "', 'true').focus();";
    }

    private class ETaskbarResources
    implements HMCSessionListener,
    PropertyChangeListener,
    Serializable {
        private final String LOGOFF_TASK_KEY = "base.task.logoff";
        private final String LOGOFF_NAME_KEY = "task.logoff.name";
        private final String TASK_ID_CONTEXT_KEY = "task.id";
        private final String TASK_PORTAL_CONTEXT_KEY = "task.portal";
        private WccTaskbar taskbar = null;
        private UserObject userObj = null;

        public synchronized WccTaskbar getResourcesDocument(RenderingContext rc, HttpSession session) throws IOException, ServletException {
            Trace.trace(TaskbarAction.TRACEMASKT, "-> ETaskbarResources.getResourcesDocument()");
            if (this.taskbar == null) {
                this.createResourcesDocument(rc, session);
            }
            Trace.trace(TaskbarAction.TRACEMASKT, "<- ETaskbarResources.getResourcesDocument()");
            return this.taskbar;
        }

        private void createResourcesDocument(RenderingContext rc, HttpSession session) throws IOException, ServletException {
            Trace.trace(TaskbarAction.TRACEMASKT, "-> ETaskbarResources.createResourcesDocument()");
            try {
                this.userObj = UserObject.getUserObject(HMCSession.getHMCSession(session));
                this.taskbar = new WccTaskbar("Active Tasks");
                this.taskbar.getTaskButtonRow().setAutoZOrder(false);
                Iterator i = this.getButtonsForAllRunningTasks(this.userObj.getHMCSession()).iterator();
                while (i.hasNext()) {
                    this.taskbar.addTaskbarButton((WccTaskbarButton)i.next(), false);
                }
                this.taskbar.addPropertyChangeListener((PropertyChangeListener)this);
                this.userObj.getHMCSession().addHMCSessionListener(this);
                WImage taskbarImage = new WImage(GraphicsConstants.getTaskbarIcon());
                this.taskbar.getLeftContainer().add((WComponent)taskbarImage);
                this.taskbar.setLeftWidth("30px");
                WImageButton helpButton = new WImageButton();
                helpButton.setTitle("Help me!");
                helpButton.setAltText("Help me!");
                helpButton.setResource((IResource)new UrlResource(GraphicsConstants.getHelpIcon()));
                helpButton.setAlign("middle");
                helpButton.setOnClick(TaskbarAction.this.getHelpOnClickScript());
                String logoffUrl = this.getLogoffTaskUrl();
                String logoffText = new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", "task.logoff.name").toString(rc.getLocale());
                WImageButton logoffButton = new WImageButton();
                logoffButton.setTitle(logoffText);
                logoffButton.setAltText(logoffText);
                logoffButton.setLinkUrl(logoffUrl);
                logoffButton.setResource((IResource)new UrlResource(GraphicsConstants.getLogoffIcon()));
                logoffButton.setAlign("middle");
                WHyperlink logoffLink = new WHyperlink(logoffUrl, logoffText);
                BaseHyperlinkStyleInfo hyperlinkStyle = new BaseHyperlinkStyleInfo();
                hyperlinkStyle.setStyleValue("lnk1", "text-decoration", (Object)"none");
                hyperlinkStyle.setStyleValue("lnk1", "font-family", (Object)"Arial, Helvetica, sans-serif");
                hyperlinkStyle.setStyleValue("lnk1", "font-size", (Object)"smaller");
                hyperlinkStyle.setPadding("lnk1", new Insets(0, 0, 0, 5));
                logoffLink.setStyleInfo((AStyleInfo)hyperlinkStyle);
                WBoxLayout logoffLayout = new WBoxLayout("horizontal");
                logoffLayout.setGap(3);
                logoffLayout.add((WComponent)logoffButton);
                logoffLayout.add((WComponent)logoffLink);
                logoffLayout.setAlignment((WComponent)logoffButton, "right");
                logoffLayout.setAlignment((WComponent)logoffLink, "left");
                WImage seperator = new WImage("/wclres/wcl/images/tbl37.gif");
                seperator.setHeight("85%");
                seperator.setAlign("middle");
                WBoxLayout rightLayout = new WBoxLayout("horizontal");
                rightLayout.setWidth(null);
                rightLayout.add((WComponent)helpButton);
                rightLayout.add((WComponent)seperator);
                rightLayout.add((WComponent)logoffLayout);
                WBoxLayout rightLayoutLayout = new WBoxLayout("horizontal");
                rightLayoutLayout.setWidth("100%");
                rightLayoutLayout.add((WComponent)rightLayout);
                rightLayoutLayout.setAlignment((WComponent)rightLayout, "right");
                this.taskbar.getRightContainer().add((WComponent)rightLayoutLayout);
                this.taskbar.setRightWidth("110px");
            }
            catch (Exception ex) {
                this.taskbar = null;
                throw new ServletException("Error creating WccTaskbar and contained objects in ETaskbarResources.", (Throwable)ex);
            }
            Trace.trace(TaskbarAction.TRACEMASKT, "<- ETaskbarResources.createResourcesDocument()");
        }

        private String getLogoffTaskUrl() {
            ObjectId objId = new ObjectId("com.ibm.hwmca.fw.managed.Task");
            objId.setKeyProperty("Name", "base.task.logoff");
            String taskId = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager().getShortId(objId);
            TaskUrl url = new TaskUrl(taskId, 1);
            return url.toString();
        }

        private List getButtonsForAllRunningTasks(HMCSession hmcSession) {
            SortedList tasks = new SortedList(new Comparator(this){
                private final /* synthetic */ ETaskbarResources this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object obj1, Object obj2) {
                    PresentationTask task1 = ((PanelModelTaskPortal)obj1).getPresentationTask();
                    PresentationTask task2 = ((PanelModelTaskPortal)obj2).getPresentationTask();
                    return task1.getStartTime().compareTo(task2.getStartTime());
                }
            }, hmcSession.getRunningTasks());
            ArrayList<WccTaskbarButton> buttons = new ArrayList<WccTaskbarButton>(tasks.size());
            Iterator i = tasks.iterator();
            while (i.hasNext()) {
                buttons.add(this.createTaskbarButton((PanelModelTaskPortal)i.next()));
            }
            return buttons;
        }

        private WccTaskbarButton createTaskbarButton(PanelModelTaskPortal taskPortal) {
            WccContext context = new WccContext();
            context.put("task.id", (Object)taskPortal.getTaskId());
            context.put("task.portal", (Object)taskPortal);
            WccTaskbarButton button = new WccTaskbarButton((IWccContext)context);
            UIInfo taskUIInfo = taskPortal.getPresentationTask().getParms().getUIInfo();
            button.setText(taskUIInfo.getName(this.userObj.getLocale()).replace('\n', ' '));
            button.setIconShown(false);
            return button;
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("IWccTaskbarProperties.TASKBAR_ITEM_ADD") || property.equals("IWccTaskbarProperties.TASKBAR_ITEM_REMOVE")) {
                UIRefreshManager.refresh(7, this.userObj.getHMCSession());
            } else if (property.equals("IWccTaskbarProperties.TASKBAR_ITEM_SELECTED") && ((Boolean)evt.getNewValue()).booleanValue()) {
                WccTaskbarButton selectedButton = (WccTaskbarButton)evt.getSource();
                selectedButton.setSelected(false);
                PanelModelTaskPortal taskPortal = (PanelModelTaskPortal)selectedButton.getContext().get("task.portal");
                boolean noPanels = false;
                try {
                    noPanels = taskPortal.isPanelStackEmpty();
                }
                catch (TaskEndedException teEx) {
                    noPanels = true;
                }
                if (noPanels) {
                    try {
                        LocalizableText title = new LocalizableText("com.ibm.hwmca.fw.tasklist.res.tasklist", "cantSwitchToPanelessTaskTitle");
                        MessageText message = new MessageText("com.ibm.hwmca.fw.tasklist.res.tasklist", "cantSwitchToPanelessTaskMessage");
                        LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                        CommonMsgApp.showMessageBox(null, title, message, MsgType.WARNING_MESSAGE, buttons);
                    }
                    catch (HException hEx) {
                        Trace.trace(TaskbarAction.TRACEMASKT, "Exception rendering \"no panels\" message.");
                        Trace.trace(TaskbarAction.TRACEMASKT, hEx);
                    }
                } else {
                    taskPortal.requestFocus();
                }
            }
        }

        public void sessionConnected(HMCSession session) {
        }

        public void sessionDisconnected(HMCSession session) {
        }

        public void sessionDestroyed(HMCSession session) {
        }

        public void clientConnectivityLost(HMCSession session) {
        }

        public void clientConnectivityGained(HMCSession session) {
        }

        public void taskStarted(HMCSession session, PanelModelTaskPortal portal) {
            new Thread(this, "TaskbarAction.ETaskbarResources.taskStarted() handler", portal){
                private final /* synthetic */ PanelModelTaskPortal val$portal;
                private final /* synthetic */ ETaskbarResources this$1;
                {
                    this.this$1 = this$1;
                    this.val$portal = val$portal;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ETaskbarResources eTaskbarResources = this.this$1;
                    synchronized (eTaskbarResources) {
                        ETaskbarResources.access$200(this.this$1).addTaskbarButton(ETaskbarResources.access$100(this.this$1, this.val$portal), false);
                    }
                }
            }.start();
        }

        public void taskRealized(HMCSession session, PanelModelTaskPortal portal) {
        }

        public void taskEnded(HMCSession session, PanelModelTaskPortal portal) {
            new Thread(this, "TaskbarAction.ETaskbarResources.taskEnded() handler", portal){
                private final /* synthetic */ PanelModelTaskPortal val$portal;
                private final /* synthetic */ ETaskbarResources this$1;
                {
                    this.this$1 = this$1;
                    this.val$portal = val$portal;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ETaskbarResources eTaskbarResources = this.this$1;
                    synchronized (eTaskbarResources) {
                        WccTaskbarButton button = null;
                        String taskId = this.val$portal.getTaskId();
                        int buttonCount = ETaskbarResources.access$200(this.this$1).getTaskbarButtonCount();
                        for (int i = 0; i < buttonCount; ++i) {
                            button = ETaskbarResources.access$200(this.this$1).getTaskbarButton(i);
                            if (!button.getContext().get("task.id").equals(taskId)) continue;
                            ETaskbarResources.access$200(this.this$1).removeTaskbarButton(button);
                            break;
                        }
                    }
                }
            }.start();
        }

        static /* synthetic */ WccTaskbarButton access$100(ETaskbarResources x0, PanelModelTaskPortal x1) {
            return x0.createTaskbarButton(x1);
        }

        static /* synthetic */ WccTaskbar access$200(ETaskbarResources x0) {
            return x0.taskbar;
        }
    }
}

